/**
 * OW2 Util
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: RecorderPoolItemState.java 4809 2009-03-15 10:13:49Z gaellalire $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.api.recorder;

/**
 * @author Gael Lalire
 */
public enum RecorderPoolItemState {

    /**
     * Fetched state.
     */
    FETCHED(false, true),

    /**
     * Recording state.
     */
    RECORDING(true, false),

    /**
     * Recorded state.
     */
    RECORDED(true, false),

    /**
     * Fetching state.
     */
    FETCHING(false, true),

    /**
     * Aborted recording state.
     */
    ABORTED_RECORDING(false, true),

    /**
     * Aborted fetching state.
     */
    ABORTED_FETCHING(true, false);

    /**
     * True if state can be fetched.
     */
    private boolean fetchable;

    /**
     * True if state can be recorded.
     */
    private boolean recordable;

    /**
     * @param fetchable true if state can be fetched
     * @param recordable true if state can be recorded
     */
    private RecorderPoolItemState(final boolean fetchable, final boolean recordable) {
        this.fetchable = fetchable;
        this.recordable = recordable;
    }

    /**
     * @return true if state can be fetched
     */
    public boolean isFetchable() {
        return fetchable;
    }

    /**
     * @return true if state can be recorded
     */
    public boolean isRecordable() {
        return recordable;
    }

}
