/**
 * OW2 Util
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: IRecorderAccessManager.java 4809 2009-03-15 10:13:49Z gaellalire $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.api.recorder.accesmanager;

import java.util.List;

import org.ow2.util.pool.impl.enhanced.api.basic.accessmanager.IAccessManager;
import org.ow2.util.pool.impl.enhanced.api.recorder.IRecorderPoolItem;
import org.ow2.util.pool.impl.enhanced.api.recorder.RecorderPoolItemState;

/**
 * @param <E> pool item type
 * @param <I> identifier type
 * @author Gael Lalire
 */
public interface IRecorderAccessManager<E, I> extends IAccessManager<IRecorderPoolItem<? extends E, ? extends I>> {

    /**
     * Ask to choose a RECORDING or ABORTED_FETCHING or RECORDED pool item.
     * If you choose an item which state is not listed above then the pool have to make a correct
     * choice ignoring your response.
     * @param poolItemList the list of pool item
     * @return a value between 0 and poolItemList.size()-1
     * If you return an
     */
    int choosePoolItemToRecord(List<? extends IRecorderPoolItem<? extends E, ? extends I>> poolItemList);

    /**
     * @param poolItemList the list of pool item
     * @return a value between 0 and poolItemList.size()-1 or
     * NO_POOL_ITEM_TO_FETCH if you do not want to fetch any item
     */
    int choosePoolItemToFetch(List<? extends IRecorderPoolItem<? extends E, ? extends I>> poolItemList);

    /**
     * @param poolItemList the list of pool item
     * @param poolItem the pool item
     * @param previousState the previous state of item (to get new state use poolItem.getState())
     * @return a distance (for example 0 : do not move, 1 : move forward, -5 : move 5 time backwards)
     */
    int movePoolItemWhoseStateChanged(List<? extends IRecorderPoolItem<? extends E, ? extends I>> poolItemList,
            IRecorderPoolItem<? extends E, ? extends I> poolItem, RecorderPoolItemState previousState);

}
