/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: PoolFactory.java 4601 2009-02-16 09:35:38Z gaellalire $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.deprecated;

import org.ow2.util.pool.api.PoolException;


/**
 * Allows to call specific methods for each implementation of the pool for each lifecycle on an object.
 * @param <InstanceType> the type of the object that are managed by the pool
 *        (could be EasyBeansSLSB, etc.)
 * @param <Clue> a clue which is given to match an instance in the pool
 * @author Florent Benoit
 * @deprecated
 */
@Deprecated
public interface PoolFactory<InstanceType, Clue> {


    /**
     * Creates an instance with the given hint.
     * @param clue always null with this implementation.
     * @throws PoolException if instance cannot be created.
     * @return the created instance.
     */
    InstanceType create(Clue clue) throws PoolException;

    /**
     * Checks if the given object with the given clue is matching.
     * @param object given object against which the check should be done.
     * @param clue the object used as clue to check the matching.
     * @return true if it is matching, else false.
     */
    boolean isMatching(InstanceType object, Clue clue);

    /**
     * Change item clue.
     * @param object given object against which the check should be done.
     * @param clue the object used as clue to check the matching.
     */
    void setClue(InstanceType object, Clue clue);


    /**
     * Callback called when object is gonna be removed.
     * @param object that is being removed from the pool.
     */
    void remove(InstanceType object);

    /**
     * This method is called just before an instance is getted.
     * You should reinit fields you set to null and saved to
     * file system for example.
     * @param object the pool item which will become busy
     * @param clue the clue used to get this instance
     */
    void activate(InstanceType object, Clue clue);

    /**
     * This method is called while an instance is put in pool.
     * You may back up and set to null some field.
     * @param object the pool item which will become available
     */
    void passivate(InstanceType object);

    /**
     * Validate an instance by giving some statistics.
     * @param instance the instance to validate
     * @return true if the element is valid, else false.
     */
    boolean validate(InstanceType instance);

}
