/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: PoolFactoryImpl.java 4759 2009-03-08 19:05:13Z gaellalire $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.deprecated;

import org.ow2.util.pool.api.PoolException;
import org.ow2.util.pool.impl.enhanced.api.IPoolItemFactory;
import org.ow2.util.pool.impl.enhanced.api.validator.clue.ICluePoolValidator;
import org.ow2.util.pool.impl.enhanced.impl.listener.clue.CluePoolListenerAdapter;

/**
 *
 * @author Gael Lalire
 * @param <E>
 * @param <C>
 * @deprecated
 */
@Deprecated
public class PoolFactoryImpl<E, C> extends CluePoolListenerAdapter<E, C> implements IPoolItemFactory<E>, ICluePoolValidator<E, C> {

    private PoolFactory<E, C> factory;

    public PoolFactoryImpl(final PoolFactory<E, C> factory) {
        this.factory = factory;
    }

    public E createPoolItem() {
        try {
            return factory.create(null);
        } catch (PoolException e) {
            e.printStackTrace();
        }
        return null;
    }

    public void setClue(final E item, final C clue) {
        factory.setClue(item, clue);
    }

    @Override
    public void getMethodReturned(final E result, final long timeout) {
        factory.activate(result, null);
    }

    @Override
    public void getMethodReturned(final E result, final C clue, final long timeout) {
        factory.activate(result, clue);
    }

    /**
     * Called after a pool item is available in pool.
     */
    @Override
    public void putMethodReturned(final E poolItem) {
        factory.passivate(poolItem);
    }

    /**
     * Called after a pool item is remove from pool.
     */
    public void poolItemReleased(final E poolItem) {
        factory.remove(poolItem);
    }

    public boolean validate(final E poolItem, final C clue) {
        return factory.validate(poolItem);
    }

    public boolean validate(final E poolItem) {
        return factory.validate(poolItem);
    }

}
