/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: ProxyLastUsedClueAccessManager.java 4759 2009-03-08 19:05:13Z gaellalire $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.deprecated;

import java.util.List;

import org.ow2.util.pool.impl.enhanced.api.clue.IClueManager;
import org.ow2.util.pool.impl.enhanced.impl.basic.accessmanager.clue.LastUsedClueAccessManager;

/**
 *
 * @author Gael Lalire
 * @param <E>
 * @param <C>
 * @deprecated
 */
@Deprecated
public class ProxyLastUsedClueAccessManager<E, C> extends LastUsedClueAccessManager<E, C> {

    private PoolFactoryImpl<E, C> poolFactoryImpl;

    public ProxyLastUsedClueAccessManager(final PoolFactoryImpl<E, C> poolFactoryImpl, final IClueManager<E, C> clueManager) {
        super(clueManager);
        this.poolFactoryImpl = poolFactoryImpl;
    }

    @Override
    public int choosePoolItemToRelease(final List<? extends E> poolItemList) {
        int release = super.choosePoolItemToRelease(poolItemList);
        poolFactoryImpl.poolItemReleased(poolItemList.get(release));
        return release;
    }

    @Override
    public void removePoolItem(final E poolItem) {
        super.removePoolItem(poolItem);
        poolFactoryImpl.poolItemReleased(poolItem);
    }

}
