/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: LastUsedClueAccessManager.java 4759 2009-03-08 19:05:13Z gaellalire $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.impl.basic.accessmanager.clue;

import java.util.List;

import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.impl.enhanced.api.basic.clue.accessmanager.IClueAccessManager;
import org.ow2.util.pool.impl.enhanced.api.clue.IClueManager;
import org.ow2.util.pool.impl.enhanced.impl.basic.accessmanager.LastUsedAccessManager;


/**
 *
 * @author Gael Lalire
 * @param <E>
 * @param <C>
 */
public class LastUsedClueAccessManager<E, C> extends LastUsedAccessManager<E> implements IClueAccessManager<E, C> {

    private static final Log LOG = LogFactory.getLog(LastUsedClueAccessManager.class);

    private IClueManager<E, C> clueManager;

    public LastUsedClueAccessManager(final IClueManager<E, C> clueManager) {
        this.clueManager = clueManager;
    }

    public int choosePoolItemToGet(final List<? extends E> poolItemList, final C clue) {
        int lastIndex = poolItemList.size() - 1;
        int index = lastIndex;
        E poolItem;
        while (index >= 0) {
            poolItem = poolItemList.get(index);
            if (clueManager.tryMatch(poolItem, clue)) {
                LOG.debug("We choose matching clue {0}.", poolItem);
                return index;
            }
            index--;
        }
        LOG.debug("Delay get");
        return DELAY_GET;
    }

    @Override
    public void removePoolItem(final E poolItem) {
        super.removePoolItem(poolItem);
        clueManager.unMatch(poolItem);
    }

    @Override
    public int putPoolItem(final java.util.List<? extends E> poolItemList, final E poolItem) {
        int pos = super.putPoolItem(poolItemList, poolItem);
        clueManager.unMatch(poolItem);
        return pos;
    }

}
