/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: BasicClueManager.java 4759 2009-03-08 19:05:13Z gaellalire $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.impl.clue.basiccluemanager;

import java.util.ArrayList;
import java.util.List;

import org.ow2.util.pool.impl.enhanced.api.clue.IClueManager;
import org.ow2.util.pool.impl.enhanced.api.clue.basiccluemanager.IClueAccessor;

/**
 * @author Gael Lalire
 * @param <E>
 * @param <C>
 */
public class BasicClueManager<E extends IClueAccessor<C>, C> implements IClueManager<E, C> {

    private List<C> busyClue;

    private boolean clueResetable;

    /**
     * Less restriction constructor.
     * Allow both reset and share of clue.
     */
    public BasicClueManager() {
        this(true, true);
    }

    public BasicClueManager(final boolean clueShareable, final boolean clueResetable) {
        this.clueResetable = clueResetable;
        if (!clueShareable) {
            busyClue = new ArrayList<C>();
        }
    }

    public boolean tryMatch(final E item, final C clue) {
        if (clue == null) {
            if (item.getClue() == null) {
                return true;
            }
            if (clueResetable) {
                item.setClue(null);
                return true;
            }
            return false;
        }
        if (busyClue != null && busyClue.contains(clue)) {
            return false;
        }
        C itemClue = item.getClue();
        if (itemClue == null) {
            item.setClue(clue);
            if (busyClue != null) {
                busyClue.add(clue);
            }
            return true;
        }
        if (itemClue.equals(clue)) {
            if (busyClue != null) {
                busyClue.add(clue);
            }
            return true;
        }
        if (clueResetable) {
            item.setClue(clue);
            if (busyClue != null) {
                busyClue.add(clue);
            }
            return true;
        }
        return false;
    }

    public void unMatch(final E item) {
        if (busyClue != null) {
            busyClue.remove(item.getClue());
        }
    }

}
