/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: CluePoolListenerDispatcherPool.java 4759 2009-03-08 19:05:13Z gaellalire $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.impl.listener.clue;

import java.util.ArrayList;
import java.util.List;

import org.ow2.util.pool.impl.enhanced.api.PoolException;
import org.ow2.util.pool.impl.enhanced.api.clue.ICluePool;
import org.ow2.util.pool.impl.enhanced.api.listener.clue.ICluePoolListener;
import org.ow2.util.pool.impl.enhanced.impl.listener.PoolListenerDispatcherPool;

/**
 *
 * @author Gael Lalire
 * @param <E>
 * @param <C>
 */
public class CluePoolListenerDispatcherPool<E, C> extends PoolListenerDispatcherPool<E> implements ICluePool<E, C> {

    private ICluePool<E, C> cluePool;

    private List<ICluePoolListener<E, C>> cluePoolListenerList;

    public CluePoolListenerDispatcherPool(final ICluePool<E, C> cluePool) {
        super(cluePool);
        this.cluePool = cluePool;
        cluePoolListenerList = new ArrayList<ICluePoolListener<E, C>>();
    }

    public E get(final C clue, final long timeout) throws PoolException {
        for (ICluePoolListener<E, C> poolListener : cluePoolListenerList) {
            poolListener.getMethodCalled(clue, timeout);
        }
        try {
            E result = cluePool.get(clue, timeout);
            for (ICluePoolListener<E, C> poolListener : cluePoolListenerList) {
                poolListener.getMethodReturned(result, clue, timeout);
            }
            return result;
        } catch (PoolException poolException) {
            for (ICluePoolListener<E, C> poolListener : cluePoolListenerList) {
                poolListener.getMethodFailed(poolException, clue, timeout);
            }
            throw poolException;
        }
    }

    public void addCluePoolListener(final ICluePoolListener<E, C> poolListener) {
        cluePoolListenerList.add(poolListener);
        addPoolListener(poolListener);
    }

    public void removeCluePoolListener(final ICluePoolListener<E, C> poolListener) {
        cluePoolListenerList.remove(poolListener);
        removePoolListener(poolListener);
    }


}
