/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: StatsResizerPool.java 4389 2008-12-15 13:48:57Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.impl.listener.resizer;

import org.ow2.util.pool.impl.enhanced.api.IPool;
import org.ow2.util.pool.impl.enhanced.api.listener.statistics.IPoolStatsListener;
import org.ow2.util.pool.impl.enhanced.impl.listener.PoolListenerDispatcherPool;
import org.ow2.util.pool.impl.enhanced.internal.resizer.api.IResizer;

/**
 *
 * @author Gael Lalire
 * @param <E>
 * @param <S>
 */
public class StatsResizerPool<E, S> extends PoolListenerDispatcherPool<E> {

    /**
     * @param pool pool to get stats
     * @param poolStatsListener fill and access stats
     * @param instance an stat instance
     * @param resizer the resizer call resize method (on another pool for example)
     */
    public StatsResizerPool(final IPool<E> pool, final IPoolStatsListener<E, S> poolStatsListener, final S instance,
            final IResizer<S> resizer) {
        super(pool);
        addPoolListener(poolStatsListener);
        // call update and prepateUpdate
        addPoolListener(new ResizerUpdatePoolListener<E, S>(instance, resizer, poolStatsListener));
    }

}
