/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: ResizerUpdateCluePoolListener.java 4389 2008-12-15 13:48:57Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.impl.listener.resizer.clue;

import org.ow2.util.pool.impl.enhanced.api.PoolException;
import org.ow2.util.pool.impl.enhanced.api.listener.clue.ICluePoolListener;
import org.ow2.util.pool.impl.enhanced.api.listener.statistics.clue.ICluePoolStatsListener;
import org.ow2.util.pool.impl.enhanced.impl.listener.resizer.ResizerUpdatePoolListener;
import org.ow2.util.pool.impl.enhanced.impl.listener.resizer.UpdateMethod;
import org.ow2.util.pool.impl.enhanced.internal.resizer.api.IResizer;

/**
 *
 * @author Gael Lalire
 * @param <E>
 * @param <C>
 * @param <S>
 */
public class ResizerUpdateCluePoolListener<E, C, S> extends ResizerUpdatePoolListener<E, S> implements ICluePoolListener<E, C> {

    private UpdateMethod getClueUpdateMethod;

    private IResizer<S> poolResizer;

    public ResizerUpdateCluePoolListener(final S stats, final IResizer<S> poolResizer,
            final ICluePoolStatsListener<E, C, S> poolStatsAccessor) {
        this(stats, poolResizer, poolStatsAccessor, UpdateMethod.BEFORE, UpdateMethod.BEFORE, UpdateMethod.AFTER,
                UpdateMethod.AFTER, UpdateMethod.AFTER);
    }

    public ResizerUpdateCluePoolListener(final S stats, final IResizer<S> poolResizer,
            final ICluePoolStatsListener<E, C, S> poolStatsAccessor, final UpdateMethod getClueUpdateMethod,
            final UpdateMethod getUpdateMethod, final UpdateMethod putUpdateMethod, final UpdateMethod removeUpdateMethod,
            final UpdateMethod interruptAllWaitersUpdateMethod) {
        super(stats, poolResizer, poolStatsAccessor, getUpdateMethod, putUpdateMethod, removeUpdateMethod,
                interruptAllWaitersUpdateMethod);
        this.getClueUpdateMethod = getClueUpdateMethod;
        this.poolResizer = poolResizer;
    }

    public void getMethodCalled(final C clue, final long timeout) {
        prepareUpdate();
        if (getClueUpdateMethod.isBefore()) {
            poolResizer.update();
        }
    }

    public void getMethodFailed(final PoolException poolException, final C clue, final long timeout) {
        prepareUpdate();
        if (getClueUpdateMethod.isAfterFailed()) {
            poolResizer.update();
        }
    }

    public void getMethodReturned(final E result, final C clue, final long timeout) {
        prepareUpdate();
        if (getClueUpdateMethod.isAfterSuccessful()) {
            poolResizer.update();
        }
    }

}
