/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: StatsResizerCluePool.java 4389 2008-12-15 13:48:57Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.impl.listener.resizer.clue;

import org.ow2.util.pool.impl.enhanced.api.clue.ICluePool;
import org.ow2.util.pool.impl.enhanced.api.listener.statistics.clue.ICluePoolStatsListener;
import org.ow2.util.pool.impl.enhanced.impl.listener.clue.CluePoolListenerDispatcherPool;
import org.ow2.util.pool.impl.enhanced.internal.resizer.api.IResizer;

/**
 *
 * @author Gael Lalire
 * @param <E>
 * @param <C>
 * @param <S>
 */
public class StatsResizerCluePool<E, C, S> extends CluePoolListenerDispatcherPool<E, C> {

    /**
     * @param pool pool to get stats
     * @param poolStatsListener fill and access stats
     * @param instance an stat instance
     * @param resizer the resizer call resize method (on another pool for example)
     */
    public StatsResizerCluePool(final ICluePool<E, C> pool, final ICluePoolStatsListener<E, C, S> poolStatsListener,
            final S instance, final IResizer<S> resizer) {
        super(pool);
        addCluePoolListener(poolStatsListener);
        // call update and prepateUpdate
        addCluePoolListener(new ResizerUpdateCluePoolListener<E, C, S>(instance, resizer, poolStatsListener));
    }

}
