/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: BasicPoolStats.java 4389 2008-12-15 13:48:57Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.impl.listener.statistics;

import org.ow2.util.pool.impl.enhanced.internal.resizer.api.statistics.StockerStatistics;

/**
 *
 * @author Gael Lalire
 */
public class BasicPoolStats implements StockerStatistics {

    private int waiters;

    private int notSendedBack;

    /**
     * @return the waiters
     */
    public int getWaiters() {
        return waiters;
    }

    /**
     * @param waiters the waiters to set
     */
    public void setWaiters(final int waiters) {
        this.waiters = waiters;
    }

    /**
     * @return the notSendedBack
     */
    public int getNotSendedBack() {
        return notSendedBack;
    }

    /**
     * @param notSendedBack the notSendedBack to set
     */
    public void setNotSendedBack(final int notSendedBack) {
        this.notSendedBack = notSendedBack;
    }

    /**
     * We assume that a pool item is stocked when it is not in pool.
     */
    public int getStockedCount() {
        return notSendedBack;
    }


}
