/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: BasicPoolStatsFillerPoolListener.java 4389 2008-12-15 13:48:57Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.impl.listener.statistics;

import org.ow2.util.pool.impl.enhanced.api.PoolException;
import org.ow2.util.pool.impl.enhanced.api.listener.statistics.IPoolStatsListener;
import org.ow2.util.pool.impl.enhanced.impl.listener.PoolListenerAdapter;

/**
 *
 * @author Gael Lalire
 * @param <E>
 */
public class BasicPoolStatsFillerPoolListener<E> extends PoolListenerAdapter<E> implements IPoolStatsListener<E, BasicPoolStats> {

    private BasicPoolStats basicPoolStats;

    public BasicPoolStatsFillerPoolListener() {
        basicPoolStats = new BasicPoolStats();
    }

    /**
     * @return the basicPoolStats
     */
    protected BasicPoolStats getBasicPoolStats() {
        return basicPoolStats;
    }

    @Override
    public void getMethodCalled(final long timeout) {
        if (timeout != 0) {
            basicPoolStats.setWaiters(basicPoolStats.getWaiters() + 1);
        }
    }

    @Override
    public void getMethodFailed(final PoolException poolException, final long timeout) {
        if (timeout != 0) {
            basicPoolStats.setWaiters(basicPoolStats.getWaiters() - 1);
        }
    }

    @Override
    public void getMethodReturned(final E result, final long timeout) {
        synchronized (basicPoolStats) {
            basicPoolStats.setNotSendedBack(basicPoolStats.getNotSendedBack() + 1);
        }
        if (timeout != 0) {
            basicPoolStats.setWaiters(basicPoolStats.getWaiters() - 1);
        }
    }

    @Override
    public void putMethodReturned(final E poolItem) {
        synchronized (basicPoolStats) {
            basicPoolStats.setNotSendedBack(basicPoolStats.getNotSendedBack() - 1);
        }
    }

    @Override
    public void removeMethodReturned(final E poolItem) {
        synchronized (basicPoolStats) {
            basicPoolStats.setNotSendedBack(basicPoolStats.getNotSendedBack() - 1);
        }
    }

    public void copyStats(final BasicPoolStats stats) {
        synchronized (basicPoolStats) {
            stats.setNotSendedBack(basicPoolStats.getNotSendedBack());
            stats.setWaiters(basicPoolStats.getWaiters());
        }
    }

}
