/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: ExtendedPoolStatsFillerPoolListener.java 4389 2008-12-15 13:48:57Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.impl.listener.statistics;

import org.ow2.util.pool.impl.enhanced.api.PoolException;

/**
 *
 * @author Gael Lalire
 * @param <E>
 */
public class ExtendedPoolStatsFillerPoolListener<E> extends BasicPoolStatsFillerPoolListener<E> {

    private ThreadLocal<Long> callTime;

    private ExtendedPoolStats extendedPoolStats;

    public ExtendedPoolStatsFillerPoolListener() {
        callTime = new ThreadLocal<Long>();
        extendedPoolStats = new ExtendedPoolStats();
    }

    @Override
    public void getMethodCalled(final long timeout) {
        callTime.set(System.currentTimeMillis());
        super.getMethodCalled(timeout);
    }

    protected void updateGetMethodDurationAverage() {
        long duration = System.currentTimeMillis() - callTime.get();
        callTime.remove();
        long oldCount = extendedPoolStats.getGetMethodCount();
        double getMethodDurationAverage = (extendedPoolStats.getGetMethodDurationAverage() * oldCount + duration)
                / (oldCount + 1);
        extendedPoolStats.setGetMethodDurationAverage(getMethodDurationAverage);
        extendedPoolStats.setGetMethodCount(oldCount + 1);
    }

    @Override
    public void getMethodFailed(final PoolException poolException, final long timeout) {
        updateGetMethodDurationAverage();
        super.getMethodFailed(poolException, timeout);
    }

    @Override
    public void getMethodReturned(final E result, final long timeout) {
        updateGetMethodDurationAverage();
        super.getMethodReturned(result, timeout);
    }

}
