/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: RecorderPoolItem.java 4809 2009-03-15 10:13:49Z gaellalire $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.impl.recorder;

import org.ow2.util.pool.impl.enhanced.api.recorder.IRecorderPoolItem;
import org.ow2.util.pool.impl.enhanced.api.recorder.RecorderPoolItemState;

/**
 *
 * @author Gael Lalire
 */
public class RecorderPoolItem<E, I> implements IRecorderPoolItem<E, I> {

    private RecorderPoolItemState recorderPoolItemState;

    public RecorderPoolItem(final E item) {
        this.item = item;
        recorderPoolItemState = RecorderPoolItemState.FETCHED;
    }

    /**
     * @return the item
     */
    public E getItem() {
        return item;
    }

    /**
     * @param item the item to set
     */
    public void setItem(final E item) {
        this.item = item;
    }

    /**
     * @param id the id to set
     */
    public void setId(final I id) {
        this.id = id;
    }

    /**
     * @return the item
     */
    public E getPoolItem() {
        return item;
    }

    /**
     * @return the id
     */
    public I getId() {
        return id;
    }

    private E item;

    /**
     * Record id.
     */
    private I id;

    public RecorderPoolItemState getState() {
        return recorderPoolItemState;
    }

    public void setState(final RecorderPoolItemState recorderPoolItemState) {
        this.recorderPoolItemState = recorderPoolItemState;
    }

    /**
     * Necessary final because {@link RecorderPool} use List.indexOf.
     */
    @Override
    public final boolean equals(final Object obj) {
        return this == obj;
    }

}
