/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: SerializablePoolItemRecorder.java 4809 2009-03-15 10:13:49Z gaellalire $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.impl.recorder.poolitemrecorder;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

import org.ow2.util.pool.impl.enhanced.api.recorder.IPoolItemRecorder;
import org.ow2.util.pool.impl.enhanced.internal.store.StoreMechanism;
import org.ow2.util.stream.api.IStreamAccessor;

/**
 *
 * @author Gael Lalire
 */
public class SerializablePoolItemRecorder<E extends Serializable> implements IPoolItemRecorder<E, IStreamAccessor> {

    private StoreMechanism storeMechanism;

    public SerializablePoolItemRecorder(final StoreMechanism storeMechanism) {
        this.storeMechanism = storeMechanism;
    }

    public IStreamAccessor record(final E poolItem, final IStreamAccessor latestStreamAccessor) {
        IStreamAccessor streamAccessor = latestStreamAccessor;
        if (streamAccessor == null) {
            streamAccessor = storeMechanism.getNewStreamAccessor();
        }
        try {
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(streamAccessor.getOutputStream());
            objectOutputStream.writeObject(poolItem);
            objectOutputStream.close();
        } catch (IOException e) {
            return null;
        }
        return streamAccessor;
    }

    public E fetch(final IStreamAccessor streamAccessor) {
        E poolItem;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(streamAccessor.getInputStream());
            poolItem = (E) objectInputStream.readObject();
            objectInputStream.close();
        } catch (IOException e) {
            return null;
        } catch (ClassNotFoundException e) {
            return null;
        }
        return poolItem;
    }

    public void remove(final IStreamAccessor identifier) {
        identifier.delete();
    }

}
