/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: ManagementThreadReusableThreadFactory.java 4389 2008-12-15 13:48:57Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.impl.thread.managementthread;

import org.ow2.util.pool.impl.enhanced.api.IPoolItemFactory;
import org.ow2.util.pool.impl.enhanced.api.thread.IReusableThread;

/**
 *
 * @author Gael Lalire
 */
public class ManagementThreadReusableThreadFactory implements IPoolItemFactory<IReusableThread> {

    private boolean daemonThreadCreator;

    public ManagementThreadReusableThreadFactory() {
        this(false);
    }

    public ManagementThreadReusableThreadFactory(final boolean daemonThreadCreator) {
        this.daemonThreadCreator = daemonThreadCreator;
    }

    public IReusableThread createPoolItem() {
        return new ManagementThreadReusableThread(daemonThreadCreator);
    }

}
