/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: WorkManagerReusableThread.java 4389 2008-12-15 13:48:57Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.impl.thread.workmanager;

import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkManager;

import org.ow2.util.log.Log;
import org.ow2.util.log.LogFactory;
import org.ow2.util.pool.impl.enhanced.api.IPool;
import org.ow2.util.pool.impl.enhanced.api.thread.IReusableThread;
import org.ow2.util.pool.impl.enhanced.impl.thread.AbstractReusableThread;

/**
 *
 * @author Gael Lalire
 */
public class WorkManagerReusableThread extends AbstractReusableThread implements Work {

    private static final Log LOG = LogFactory.getLog(WorkManagerReusableThread.class);

    private WorkManager workManager;

    public WorkManagerReusableThread(final WorkManager workManager) {
        this.workManager = workManager;
    }

    @Override
    public void setUsed(final IPool<IReusableThread> reusableThreadPool, final Runnable runnable) {
        super.setUsed(reusableThreadPool, runnable);
        try {
            // we don't care is there is no available thread
            // this is better to return speedly
            workManager.scheduleWork(this);
        } catch (WorkException e) {
            LOG.error("Unable to schedule a work", e);
        }
    }

    public void release() {
    }

}
