/**
 * OW2 Util
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: LockFactory.java 4759 2009-03-08 19:05:13Z gaellalire $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.impl.util;

import java.util.concurrent.locks.Lock;

import org.ow2.util.pool.impl.enhanced.internal.lock.impl.BasicLock;

/**
 * All pools use this class to construct their locks.
 * So you can easyly change implementation
 * @author Gael Lalire
 */
public final class LockFactory {

    /**
     * Utility class.
     */
    private LockFactory() {
    }

    /**
     * @return a lock
     */
    public static Lock createLock() {
//        return new ReentrantLock();
        return new BasicLock();
    }

}
