/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: ValidatorPool.java 4389 2008-12-15 13:48:57Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.impl.validator;

import org.ow2.util.pool.impl.enhanced.api.IPool;
import org.ow2.util.pool.impl.enhanced.api.NotABusyPoolItemException;
import org.ow2.util.pool.impl.enhanced.api.PoolException;
import org.ow2.util.pool.impl.enhanced.api.validator.IPoolValidator;

/**
 * @author Gael Lalire
 */
public class ValidatorPool<E> implements IPool<E> {

    private IPool<E> pool;

    private IPoolValidator<E> poolValidator;

    private boolean putValidate;

    public ValidatorPool(final IPool<E> pool, final IPoolValidator<E> poolValidator, final boolean putValidate) {
        this.pool = pool;
        this.poolValidator = poolValidator;
        this.putValidate = putValidate;
    }

    public E get(final long timeout) throws PoolException {
        E poolItem = pool.get(timeout);
        while (!poolValidator.validate(poolItem)) {
            try {
                pool.remove(poolItem);
            } catch (NotABusyPoolItemException e) {
                throw new Error("Delegated pool has a bad behavior");
            }
            poolItem = pool.get(timeout);
        }
        return poolItem;
    }

    public void interruptAllWaiters() {
        pool.interruptAllWaiters();
    }

    public void put(final E poolItem) throws NotABusyPoolItemException {
        if (putValidate && !poolValidator.validate(poolItem)) {
            pool.remove(poolItem);
        } else {
            pool.put(poolItem);
        }
    }

    public void remove(final E poolItem) throws NotABusyPoolItemException {
        pool.remove(poolItem);
    }

}
