/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: ValidatorCluePool.java 4389 2008-12-15 13:48:57Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.impl.validator.clue;

import org.ow2.util.pool.impl.enhanced.api.NotABusyPoolItemException;
import org.ow2.util.pool.impl.enhanced.api.PoolException;
import org.ow2.util.pool.impl.enhanced.api.clue.ICluePool;
import org.ow2.util.pool.impl.enhanced.api.validator.clue.ICluePoolValidator;
import org.ow2.util.pool.impl.enhanced.impl.validator.ValidatorPool;

/**
 *
 * @author Gael Lalire
 */
public class ValidatorCluePool<E, C> extends ValidatorPool<E> implements ICluePool<E, C> {

    private ICluePool<E, C> cluePool;

    private ICluePoolValidator<E, C> cluePoolValidator;

    public ValidatorCluePool(final ICluePool<E, C> cluePool, final ICluePoolValidator<E, C> cluePoolValidator, final boolean putValidate) {
        super(cluePool, cluePoolValidator, putValidate);
        this.cluePool = cluePool;
        this.cluePoolValidator = cluePoolValidator;
    }

    public E get(final C clue, final long timeout) throws PoolException {
        E poolItem = cluePool.get(clue, timeout);
        while (!cluePoolValidator.validate(poolItem, clue)) {
            try {
                cluePool.remove(poolItem);
            } catch (NotABusyPoolItemException e) {
                throw new Error("Delegated pool has a bad behavior");
            }
            poolItem = cluePool.get(timeout);
        }
        return poolItem;
    }

}
