/**
 * OW2 Util
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: Average.java 4601 2009-02-16 09:35:38Z gaellalire $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.internal.actionscheduler;

/**
 * @author Gael Lalire
 */
public class Average {

    private long[] ls;

    private long total;

    private int i;

    private int size;

    public Average(final int keepedElement) {
        ls = new long[keepedElement];
        i = 0;
        size = 0;
    }

    public synchronized void addElement(final long l) {
        i = i + 1 % ls.length;
        if (size < ls.length) {
            size++;
        } else {
            total -= ls[i];
        }
        ls[i] = l;
        total += l;
    }

    public synchronized double getAverage() {
        return ((double) total) / size;
    }


}
