/**
 * OW2 Util
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: IActionScheduler.java 4601 2009-02-16 09:35:38Z gaellalire $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.internal.actionscheduler;


/**
 * An action scheduler always schedules the same action.
 * So we can cancel any of them.
 *
 * An action can be performed too late so the functional code abort it.
 * Functional code have to return false if action was aborted.
 *
 * If scheduleAction perform the action in his thread, the cancelAction will
 * returns almost always 0 (it could returns 1 but this imply concurrent call).
 *
 * @author Gael Lalire
 */
public interface IActionScheduler {

    void scheduleAction(final int time);

    int cancelAction(final int time);

}