/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: ISignalClearableCondition.java 4759 2009-03-08 19:05:13Z gaellalire $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.internal.lock.api;

import java.util.concurrent.locks.Condition;

/**
 *
 * @author Gael Lalire
 */
public interface ISignalClearableCondition extends Condition {

    /**
     * Avoid all signals so signaled threads SHOULD not be unpark.
     * This is not guaranteed behavior so keep your check.
     *
     * This imply that signal and signalAll methods do not
     * unpark threads immediately but only mark them as signaled.
     */
    void clearAllSignal();

    /**
     * Same behaviour as Object.wait.
     * @param timeout timeout in milliseconds, 0 have to imply infinite wait
     * @throws InterruptedException if thread was interrupted
     */
    void await(long timeout) throws InterruptedException;

}
