/**
 * OW2 Util
 * Copyright (C) 2009 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: SignalClearableConditionProxy.java 4759 2009-03-08 19:05:13Z gaellalire $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.internal.lock.impl;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;

import org.ow2.util.pool.impl.enhanced.internal.lock.api.ISignalClearableCondition;

/**
 *
 * @author Gael Lalire
 */
public class SignalClearableConditionProxy implements ISignalClearableCondition {

    private Condition condition;

    public SignalClearableConditionProxy(final Condition condition) {
        if (condition == null) {
            throw new NullPointerException();
        }
        this.condition = condition;
    }

    /**
     * Use this to create a proxy which do nothing on clearAllSignal.
     * @param condition
     * @return
     */
    public static ISignalClearableCondition createProxy(final Condition condition) {
        if (condition instanceof ISignalClearableCondition) {
            return (ISignalClearableCondition) condition;
        }
        return new SignalClearableConditionProxy(condition);
    }

    /**
     * Do nothing.
     */
    public void clearAllSignal() {
    }

    public void await() throws InterruptedException {
        condition.await();
    }

    public boolean await(final long time, final TimeUnit unit) throws InterruptedException {
        return condition.await(time, unit);
    }

    public long awaitNanos(final long nanosTimeout) throws InterruptedException {
        return condition.awaitNanos(nanosTimeout);
    }

    public void awaitUninterruptibly() {
        condition.awaitUninterruptibly();
    }

    public boolean awaitUntil(final Date deadline) throws InterruptedException {
        return condition.awaitUntil(deadline);
    }

    public void signal() {
        condition.signal();
    }

    public void signalAll() {
        condition.signalAll();
    }

    public void await(final long timeout) throws InterruptedException {
        if (timeout < 0) {
            throw new IllegalArgumentException();
        }
        if (timeout == 0) {
            condition.await();
        } else {
            condition.await(timeout, TimeUnit.MILLISECONDS);
        }
    }

}
