/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: IResizer.java 4389 2008-12-15 13:48:57Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.internal.resizer.api;


/**
 * A pool resizer can only manage one pool.
 * @author Gael Lalire
 */
public interface IResizer<S> {

    /**
     * This method is not synchronized you have to
     * avoid parallels call.
     *
     * This function is called just after a pool item is get or released.
     * So if you set expectedSize with same or less value than usedPoolItem the pool
     * will be blocking.
     *
     * @param stats statistics
     */
     void prepareUpdate(S stats);

    /**
     * You can do parallels call to this method.
     * This method grant that eventually at least a call will
     * be made to setExpectedSize
     */
     void update();

     /**
      * Resizer will call method on it.
      * @param resizable a resizable
      */
     void setResizable(final IResizable resizable);

}
