/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: AbstractResizer.java 4389 2008-12-15 13:48:57Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.internal.resizer.impl;

import org.ow2.util.pool.impl.enhanced.internal.resizer.api.IResizable;
import org.ow2.util.pool.impl.enhanced.internal.resizer.api.IResizer;

/**
 *
 * @author Gael Lalire
 */
public abstract class AbstractResizer<S> implements IResizer<S> {

    private Object mutex;

    private IResizable resizable;

    public AbstractResizer() {
        mutex = new Object();
        this.resizable = null;
    }

    protected void updateWith(final int expectedSize) {
        IResizable resizable = null;
        synchronized (mutex) {
            if (this.resizable != null) {
                resizable = this.resizable;
            }
        }
        if (resizable != null) {
            resizable.setExpectedSize(expectedSize);
        }
    }

    public void setResizable(final IResizable resizablePool) {
        synchronized (mutex) {
            this.resizable = resizablePool;
        }
    }

}
