/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: AsynchronousResizer.java 4389 2008-12-15 13:48:57Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.internal.resizer.impl;

import org.ow2.util.pool.impl.enhanced.internal.resizer.api.IResizable;
import org.ow2.util.pool.impl.enhanced.internal.resizer.api.IResizer;
import org.ow2.util.pool.impl.enhanced.internal.thread.impl.ManagementThread;

/**
 *
 * @author Gael Lalire
 */
public class AsynchronousResizer<S> implements IResizer<S>, Runnable {

    private ManagementThread[] managementThreads;

    private IResizer<S> resizer;

    private boolean willRun;

    public AsynchronousResizer(final IResizer<S> poolResizer) {
        this(poolResizer, 1);
    }

    public AsynchronousResizer(final IResizer<S> poolResizer, final int threadCount) {
        this.resizer = poolResizer;
        managementThreads = new ManagementThread[threadCount];
        for (int i = 0; i < threadCount; i++) {
            managementThreads[i] = new ManagementThread(this);
        }
    }

    public void prepareUpdate(final S state) {
        resizer.prepareUpdate(state);
    }

    public void update() {
        synchronized (managementThreads) {
            willRun = true;
        }
        for (int i = 0; i < managementThreads.length; i++) {
            managementThreads[i].start();
        }
    }

    public void run() {
        boolean doUpdate;
        synchronized (managementThreads) {
            doUpdate = willRun;
        }
        if (doUpdate) {
            resizer.update();
        }
    }

    public void setResizable(final IResizable resizable) {
        synchronized (managementThreads) {
            willRun = false;
        }
        resizer.setResizable(resizable);
    }

}
