/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: SharedResizerOneThreadManager.java 4389 2008-12-15 13:48:57Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.internal.resizer.impl.shared;

import java.util.ArrayList;
import java.util.List;

import org.ow2.util.pool.impl.enhanced.internal.resizer.api.IResizer;
import org.ow2.util.pool.impl.enhanced.internal.resizer.api.shared.ISharedManager;
import org.ow2.util.pool.impl.enhanced.internal.thread.impl.ManagementThread;

/**
 * @author Gael Lalire
 */
public class SharedResizerOneThreadManager implements ISharedManager, Runnable {

    private List<IResizer<?>> resizerList;

    private ManagementThread managementThread;

    private boolean running;

    public SharedResizerOneThreadManager() {
        resizerList = new ArrayList<IResizer<?>>();
        managementThread = new ManagementThread(this);
        running = false;
    }

    public void update(final IResizer<?> resizer) {
        synchronized (resizerList) {
            if (!running) {
                // if management thread is not started then start it
                managementThread.start();
            }
            resizerList.add(resizer);
        }
    }

    public void run() {
        synchronized (resizerList) {
            running = true;
        }
        while (true) {
            IResizer<?> resizer;
            synchronized (resizerList) {
                if (resizerList.isEmpty()) {
                    running = false;
                    return;
                }
                resizer = resizerList.remove(0);
            }
            resizer.update();
        }
    }

    /**
     * @return the resizerList
     */
    protected List<IResizer<?>> getResizerList() {
        return resizerList;
    }

    /**
     * @return the managementThread
     */
    protected ManagementThread getManagementThread() {
        return managementThread;
    }


    /**
     * @return the running
     */
    protected boolean isRunning() {
        return running;
    }

}
