/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: SharedResizerPoolThreadManager.java 4389 2008-12-15 13:48:57Z alitokmen $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.internal.resizer.impl.shared;

import org.ow2.util.pool.impl.enhanced.api.IPool;
import org.ow2.util.pool.impl.enhanced.api.PoolException;
import org.ow2.util.pool.impl.enhanced.api.thread.IReusableThread;
import org.ow2.util.pool.impl.enhanced.internal.resizer.api.IResizer;

/**
 *
 * @author Gael Lalire
 */
public class SharedResizerPoolThreadManager extends SharedResizerOneThreadManager {

    private IPool<IReusableThread> reusableThreadPool;

    public SharedResizerPoolThreadManager(final IPool<IReusableThread> reusableThreadPool) {
        this.reusableThreadPool = reusableThreadPool;
    }

    @Override
    public void update(final IResizer<?> resizer) {
        // the thread manager will update size
        super.update(resizer);
        // but if thread manager is busy with another resizer
        // instead of waiting for it we ask a thread from the
        // thread pool to do the same stuff
        try {
            // after run on this is done the IReusableThread send back itself in the pool
            reusableThreadPool.get(0).setUsed(reusableThreadPool, this);
        } catch (PoolException e) {
        }
    }

}
