/**
 * OW2 Util
 * Copyright (C) 2008 Bull S.A.S.
 * Contact: easybeans@ow2.org
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA
 *
 * --------------------------------------------------------------------------
 * $Id: FilesInFolderStoreMechanism.java 4601 2009-02-16 09:35:38Z gaellalire $
 * --------------------------------------------------------------------------
 */

package org.ow2.util.pool.impl.enhanced.internal.store;

import java.io.File;

import org.ow2.util.stream.api.IStreamAccessor;
import org.ow2.util.stream.impl.file.SystemFileAccessor;


/**
 *
 * @author Gael Lalire
 */
public class FilesInFolderStoreMechanism implements StoreMechanism {

    private long nextId;

    private File directory;

    private String prefix;

    private String suffix;

    private Object mutex;

    public FilesInFolderStoreMechanism(final File directory, final String prefix, final String suffix) {
        if (prefix == null || suffix == null) {
            throw new IllegalArgumentException();
        }
        if (directory == null || !directory.isDirectory()) {
            throw new IllegalArgumentException();
        }
        this.directory = directory;
        this.prefix = prefix;
        this.suffix = suffix;
        mutex = new Object();
    }

    public IStreamAccessor getNewStreamAccessor() {
        long currentId;
        synchronized (mutex) {
            currentId = nextId;
            nextId++;
        }
        return new SystemFileAccessor(new File(directory, prefix + currentId + suffix));
    }

}
