/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.ossindex.service.client.transport;

import com.google.common.base.Preconditions;
import com.google.common.io.BaseEncoding;
import java.io.UnsupportedEncodingException;
import javax.annotation.Nullable;
import org.sonatype.ossindex.service.client.transport.AuthConfiguration;

public class BasicAuthHelper {
    private BasicAuthHelper() {
    }

    @Nullable
    public static String authorizationHeader(@Nullable AuthConfiguration configuration) {
        if (configuration == null) {
            return null;
        }
        String username = configuration.getUsername();
        Preconditions.checkState((username != null ? 1 : 0) != 0, (Object)"Missing: username");
        String password = configuration.getPassword();
        Preconditions.checkState((password != null ? 1 : 0) != 0, (Object)"Missing: password");
        String encoded = BaseEncoding.base64().encode(BasicAuthHelper.bytesOf(String.valueOf(username) + ":" + password));
        return "Basic " + encoded;
    }

    private static byte[] bytesOf(String value) {
        try {
            return value.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

