/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.jdiagnostics;

import java.util.Arrays;
import org.anarres.jdiagnostics.ClassExistsQuery;
import org.anarres.jdiagnostics.FieldExistsGetQuery;
import org.anarres.jdiagnostics.Result;

public class ClassFieldExistsGetQuery
extends ClassExistsQuery {
    private final Object target;
    private final String[] fieldNames;

    public ClassFieldExistsGetQuery(Object target, String className, String fieldName0, String ... fieldNames) {
        super(className);
        this.target = target;
        this.fieldNames = this.array(String.class, fieldName0, fieldNames);
    }

    public String getName() {
        return "classFieldExistsGet/" + this.className + "." + Arrays.toString(this.fieldNames);
    }

    public void call(Result result, String prefix) {
        Class<?> type = new ClassExistsQuery(this.className).findClass(result, prefix);
        if (type == null) {
            return;
        }
        for (String fieldName : this.fieldNames) {
            new FieldExistsGetQuery(this.target, type, fieldName).call(result, prefix + fieldName + "/");
        }
    }
}

