/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.jdiagnostics;

import java.util.LinkedHashMap;
import org.anarres.jdiagnostics.AbstractQuery;
import org.anarres.jdiagnostics.Result;

public class ClassLoaderQuery
extends AbstractQuery {
    private final String name;
    private final ClassLoader loader;

    public ClassLoaderQuery(String name, ClassLoader loader) {
        this.name = name;
        this.loader = loader;
    }

    public String getName() {
        return "classLoader/" + this.name;
    }

    protected Result newResult() {
        return new Result(new LinkedHashMap<String, Object>());
    }

    public void call(Result result, String prefix) {
        ClassLoader l = this.loader;
        int i = 0;
        while (l != null) {
            result.put("loaderClass[" + i + "]", l.getClass());
            result.put("loader[" + i + "]", l);
            l = l.getParent();
            ++i;
        }
    }
}

