/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.jdiagnostics;

import java.util.Arrays;
import org.anarres.jdiagnostics.ClassExistsQuery;
import org.anarres.jdiagnostics.MethodExistsCallQuery;
import org.anarres.jdiagnostics.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassMethodExistsCallQuery
extends ClassExistsQuery {
    private final Object target;
    public final String methodName;
    private final Class<?>[] parameterTypes;
    private final Object[] arguments;

    public ClassMethodExistsCallQuery(Object target, String className, String methodName, Class<?>[] parameterTypes, Object[] arguments) {
        super(className);
        this.target = target;
        this.methodName = methodName;
        this.parameterTypes = parameterTypes;
        this.arguments = arguments;
    }

    public ClassMethodExistsCallQuery(Object target, String className, String methodName) {
        this(target, className, methodName, new Class[0], new Object[0]);
    }

    @Override
    public String getName() {
        return "classMethodExistsCall/" + this.className + "/" + this.methodName + " " + Arrays.toString(this.parameterTypes);
    }

    public Object invoke(Result result, String prefix) {
        Class<?> type = new ClassExistsQuery(this.className).findClass(result, prefix);
        if (type == null) {
            return null;
        }
        return new MethodExistsCallQuery(this.target, type, this.methodName, this.parameterTypes, this.arguments).invoke(result, prefix);
    }

    @Override
    public void call(Result result, String prefix) {
        this.invoke(result, prefix);
    }
}

