/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.jdiagnostics;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import org.anarres.jdiagnostics.AbstractQuery;
import org.anarres.jdiagnostics.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarQuery
extends AbstractQuery {
    public static final Properties jarTable = new Properties();
    private final String jarName;

    private static void load(Properties properties, String name) {
        try {
            InputStream is = JarQuery.class.getResourceAsStream(name);
            if (is == null) {
                return;
            }
            try {
                properties.load(is);
            }
            finally {
                is.close();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public JarQuery(String jarName) {
        this.jarName = jarName;
    }

    @Override
    public String getName() {
        return "jar/" + this.jarName;
    }

    public void stat(Result result, String prefix, File file) {
        boolean exists = file.exists();
        result.put(prefix + "/exists", exists);
        if (!exists) {
            return;
        }
        String key = file.length() + "_" + file.getName();
        String value = jarTable.getProperty(key);
        if (value != null) {
            result.put(prefix + "/release", value);
        }
    }

    public static List<String> get_path(Result result, String prefix, String pathName) {
        String path = System.getProperty(pathName);
        if (path == null) {
            return null;
        }
        ArrayList<String> out = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(path, File.pathSeparator);
        while (st.hasMoreTokens()) {
            out.add(st.nextToken());
        }
        return out;
    }

    public void search_path(Result result, String prefix, String pathName) {
        List<String> path = JarQuery.get_path(result, prefix = prefix + "/" + pathName, pathName);
        if (path == null) {
            return;
        }
        for (String element : path) {
            if (element.indexOf(this.jarName) <= -1) continue;
            this.stat(result, prefix + "/-" + element, new File(element));
        }
    }

    public void search_dirs(Result result, String prefix, String pathName) {
        List<String> path = JarQuery.get_path(result, prefix = prefix + "/" + pathName, pathName);
        if (path == null) {
            return;
        }
        for (String element : path) {
            File file = new File(element, this.jarName);
            if (!file.exists()) continue;
            this.stat(result, prefix, file);
        }
    }

    @Override
    public void call(Result result, String prefix) {
        this.search_path(result, prefix, "java.class.path");
        this.search_path(result, prefix, "sun.boot.class.path");
        this.search_dirs(result, prefix, "java.ext.dirs");
    }

    static {
        JarQuery.load(jarTable, "JarQuery.properties");
    }
}

