/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.ossindex.service.client.transport;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;

public class UserAgentBuilder {
    private final List<Product> products = new LinkedList<Product>();

    public UserAgentBuilder product(Product product) {
        this.products.add(product);
        return this;
    }

    public String build() {
        Preconditions.checkState((!this.products.isEmpty() ? 1 : 0) != 0, (Object)"At least one product must be specified");
        StringBuilder buff = new StringBuilder();
        Iterator<Product> iter = this.products.iterator();
        while (iter.hasNext()) {
            Product product = iter.next();
            buff.append(product.name);
            if (product.version != null) {
                buff.append('/').append(product.version);
            }
            if (product.comments != null) {
                buff.append(' ').append('(');
                buff.append(Joiner.on((String)product.separator).join((Iterable)product.comments));
                buff.append(')');
            }
            if (!iter.hasNext()) continue;
            buff.append(' ');
        }
        return buff.toString();
    }

    public static class Product {
        private final String name;
        @Nullable
        private final String version;
        private String separator = "; ";
        @Nullable
        private List<String> comments;

        public Product(String name, @Nullable String version) {
            this.name = (String)Preconditions.checkNotNull((Object)name);
            this.version = version;
        }

        public Product(String name) {
            this(name, null);
        }

        public Product seperator(String separator) {
            this.separator = (String)Preconditions.checkNotNull((Object)separator);
            return this;
        }

        public Product comment(String ... values) {
            if (this.comments == null) {
                this.comments = new LinkedList<String>();
            }
            this.comments.addAll(Arrays.asList(values));
            return this;
        }
    }
}

