/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.ossindex.service.client.transport;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.ossindex.service.client.internal.Version;
import org.sonatype.ossindex.service.client.transport.UserAgentBuilder;

public class UserAgentSupplier
implements Supplier<String> {
    private static final Logger log = LoggerFactory.getLogger(UserAgentSupplier.class);
    public static final String PRODUCT = "ossindex-client";
    private final String value;

    public UserAgentSupplier(Version version) {
        this(PRODUCT, version.getVersion());
    }

    @VisibleForTesting
    public UserAgentSupplier(String product, String version) {
        Preconditions.checkNotNull((Object)product);
        Preconditions.checkNotNull((Object)version);
        UserAgentBuilder builder = new UserAgentBuilder().product(new UserAgentBuilder.Product(product, version).comment(System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"), System.getProperty("java.version")));
        this.customize(builder);
        this.value = builder.build();
        log.debug("User-agent: {}", (Object)this.value);
    }

    protected void customize(UserAgentBuilder builder) {
    }

    public String get() {
        return this.value;
    }
}

