/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.golang;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.stream.JsonParsingException;
import org.owasp.dependencycheck.analyzer.exception.AnalysisException;
import org.owasp.dependencycheck.data.golang.GoModDependency;
import org.owasp.dependencycheck.utils.JsonArrayFixingInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public final class GoModJsonParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(GoModJsonParser.class);

    private GoModJsonParser() {
    }

    public static List<GoModDependency> process(InputStream inputStream) throws AnalysisException {
        LOGGER.debug("Beginning go.mod processing");
        ArrayList<GoModDependency> goModDependencies = new ArrayList<GoModDependency>();
        try (JsonArrayFixingInputStream jsonStream = new JsonArrayFixingInputStream(inputStream);){
            JsonReaderFactory factory = Json.createReaderFactory(null);
            try (JsonReader reader = factory.createReader((InputStream)jsonStream, StandardCharsets.UTF_8);){
                JsonArray modules = reader.readArray();
                modules.getValuesAs(JsonObject.class).forEach(module -> {
                    String path = module.getString("Path");
                    String version = module.getString("Version", null);
                    if (version != null && version.startsWith("v")) {
                        version = version.substring(1);
                    }
                    String dir = null;
                    if (module.getJsonString("Dir") != null) {
                        dir = module.getString("Dir");
                    }
                    goModDependencies.add(new GoModDependency(path, version, dir));
                });
            }
        }
        catch (JsonParsingException jsonpe) {
            throw new AnalysisException("Error parsing output from `go list -json -m all`", jsonpe);
        }
        catch (JsonException jsone) {
            throw new AnalysisException("Error reading output from `go list -json -m all`", jsone);
        }
        catch (IllegalStateException ise) {
            throw new AnalysisException("Illegal state in go mod stream", ise);
        }
        catch (ClassCastException cce) {
            throw new AnalysisException("JSON not exactly matching output of `go list -json -m all`", cce);
        }
        catch (IOException ex) {
            throw new AnalysisException("Error reading output of `go list -json -m all`", ex);
        }
        return goModDependencies;
    }
}

