/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.data.nvd.ecosystem;

import com.hankcs.algorithm.AhoCorasickDoubleArrayTrie;
import io.github.jeremylong.openvulnerability.client.nvd.CveItem;
import io.github.jeremylong.openvulnerability.client.nvd.DefCveItem;
import io.github.jeremylong.openvulnerability.client.nvd.Reference;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import javax.annotation.concurrent.NotThreadSafe;
import org.owasp.dependencycheck.data.nvd.ecosystem.UrlHostHint;
import org.owasp.dependencycheck.data.nvd.ecosystem.UrlPathHint;

@NotThreadSafe
public class UrlEcosystemMapper {
    private static final TreeMap<String, String> ECOSYSTEM_MAP = new TreeMap();
    private final AhoCorasickDoubleArrayTrie<String> search = new AhoCorasickDoubleArrayTrie();

    public UrlEcosystemMapper() {
        this.search.build(ECOSYSTEM_MAP);
    }

    public String getEcosystem(DefCveItem cve) {
        List references = Optional.ofNullable(cve).map(DefCveItem::getCve).map(CveItem::getReferences).orElse(null);
        if (Objects.nonNull(references)) {
            for (Reference r : references) {
                AhoCorasickDoubleArrayTrie.Hit ecosystem = this.search.findFirst(r.getUrl());
                if (ecosystem == null) continue;
                return (String)ecosystem.value;
            }
        }
        return null;
    }

    static {
        for (UrlHostHint urlHostHint : UrlHostHint.values()) {
            ECOSYSTEM_MAP.put(urlHostHint.getValue(), urlHostHint.getEcosystem());
        }
        for (Enum enum_ : UrlPathHint.values()) {
            ECOSYSTEM_MAP.put(((UrlPathHint)enum_).getValue(), ((UrlPathHint)enum_).getEcosystem());
        }
    }
}

