/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.goodies.packageurl.jackson;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.type.WritableTypeId;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import javax.annotation.Nullable;
import org.sonatype.goodies.packageurl.PackageUrl;
import org.sonatype.goodies.packageurl.RenderFlavor;

public class PackageUrlModule
extends SimpleModule {
    private static final long serialVersionUID = 1L;
    @Nullable
    private RenderFlavor flavor;

    public PackageUrlModule withFlavor(@Nullable RenderFlavor flavor) {
        this.flavor = flavor;
        return this;
    }

    public void setupModule(Module.SetupContext context) {
        this.addSerializer(PackageUrl.class, (JsonSerializer)new PackageUrlSerializer(this.flavor));
        this.addDeserializer(PackageUrl.class, (JsonDeserializer)new PackageUrlDeserializer());
        super.setupModule(context);
    }

    public static class PackageUrlDeserializer
    extends StdDeserializer<PackageUrl> {
        private static final long serialVersionUID = 1L;

        public PackageUrlDeserializer() {
            super(PackageUrl.class);
        }

        public PackageUrl deserialize(JsonParser parser, DeserializationContext context) throws IOException, JsonProcessingException {
            String value = (String)parser.readValueAs(String.class);
            return PackageUrl.parse(value);
        }
    }

    public static class PackageUrlSerializer
    extends StdSerializer<PackageUrl> {
        private static final long serialVersionUID = 1L;
        @Nullable
        private final RenderFlavor flavor;

        public PackageUrlSerializer(@Nullable RenderFlavor flavor) {
            super(PackageUrl.class);
            this.flavor = flavor;
        }

        public void serialize(PackageUrl value, JsonGenerator generator, SerializerProvider provider) throws IOException {
            generator.writeString(value.toString(this.flavor != null ? this.flavor : RenderFlavor.getDefault()));
        }

        public void serializeWithType(PackageUrl value, JsonGenerator generator, SerializerProvider provider, TypeSerializer serializer) throws IOException {
            WritableTypeId typeId = serializer.writeTypePrefix(generator, serializer.typeId((Object)value, JsonToken.VALUE_STRING));
            this.serialize(value, generator, provider);
            serializer.writeTypeSuffix(generator, typeId);
        }
    }
}

