/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.goodies.packageurl.jaxrs;

import com.google.common.base.Preconditions;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import javax.ws.rs.ext.ParamConverter;
import javax.ws.rs.ext.ParamConverterProvider;
import javax.ws.rs.ext.Provider;
import org.sonatype.goodies.packageurl.PackageUrl;
import org.sonatype.goodies.packageurl.RenderFlavor;

public class PackageUrlParamConverter
implements ParamConverter<PackageUrl> {
    @Nullable
    private final RenderFlavor flavor;

    public PackageUrlParamConverter(@Nullable RenderFlavor flavor) {
        this.flavor = flavor;
    }

    public PackageUrl fromString(String value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0);
        return PackageUrl.parse(value);
    }

    public String toString(PackageUrl value) {
        Preconditions.checkArgument((value != null ? 1 : 0) != 0);
        return value.toString(this.flavor != null ? this.flavor : RenderFlavor.getDefault());
    }

    @Provider
    public static class ProviderImpl
    implements ParamConverterProvider {
        @Nullable
        private final RenderFlavor flavor;

        public ProviderImpl(RenderFlavor flavor) {
            this.flavor = flavor;
        }

        public ProviderImpl() {
            this(null);
        }

        public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
            Preconditions.checkNotNull(rawType);
            if (rawType.equals(PackageUrl.class)) {
                return new PackageUrlParamConverter(this.flavor);
            }
            return null;
        }
    }
}

