/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.ossindex.service.api.componentreport;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.sonatype.goodies.packageurl.PackageUrl;
import org.sonatype.goodies.packageurl.jaxb.PackageUrlXmlAdapter;
import org.sonatype.ossindex.service.api.componentreport.ComponentReportVulnerability;

@ApiModel(description="Component vulnerability report")
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ComponentReport
implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value="Component coordinates as package-url")
    @JsonProperty
    @XmlElement
    @XmlJavaTypeAdapter(value=PackageUrlXmlAdapter.class)
    private PackageUrl coordinates;
    @ApiModelProperty(value="Component description")
    @JsonProperty
    @XmlElement
    private String description;
    @ApiModelProperty(value="Component details reference")
    @JsonProperty
    @XmlElement
    private URI reference;
    @ApiModelProperty(value="Vulnerabilities recorded for component")
    @JsonProperty
    @XmlElementWrapper
    @XmlElement(name="vulnerability")
    private List<ComponentReportVulnerability> vulnerabilities;
    @ApiModelProperty(value="Sonatype Ossi Score")
    @JsonProperty
    @XmlElement(name="sonatype:ossi:score")
    private float sonatypeOssiScore;

    public PackageUrl getCoordinates() {
        return this.coordinates;
    }

    public void setCoordinates(PackageUrl coordinates) {
        this.coordinates = coordinates;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public URI getReference() {
        return this.reference;
    }

    public void setReference(URI reference) {
        this.reference = reference;
    }

    public List<ComponentReportVulnerability> getVulnerabilities() {
        if (this.vulnerabilities == null) {
            this.vulnerabilities = new ArrayList<ComponentReportVulnerability>();
        }
        return this.vulnerabilities;
    }

    public void setVulnerabilities(List<ComponentReportVulnerability> vulnerabilities) {
        this.vulnerabilities = vulnerabilities;
    }

    public Float getSonatypeOssiScore() {
        return Float.valueOf(this.sonatypeOssiScore);
    }

    public void setSonatypeOssiScore(float sonatypeOssiScore) {
        this.sonatypeOssiScore = sonatypeOssiScore;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentReport that = (ComponentReport)o;
        return Objects.equals(this.coordinates, that.coordinates) && Objects.equals(this.description, that.description) && Objects.equals(this.reference, that.reference) && this.sonatypeOssiScore == that.sonatypeOssiScore && Objects.equals(this.vulnerabilities, that.vulnerabilities);
    }

    public int hashCode() {
        return Objects.hash(this.coordinates, this.description, this.reference, Float.valueOf(this.sonatypeOssiScore), this.vulnerabilities);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("coordinates", (Object)this.coordinates).add("description", (Object)this.description).toString();
    }
}

