/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.ossindex.service.api.componentreport;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.sonatype.goodies.packageurl.PackageUrl;
import org.sonatype.goodies.packageurl.jaxb.PackageUrlXmlAdapter;

@ApiModel(description="Component vulnerability report request")
@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class ComponentReportRequest
implements Serializable {
    private static final long serialVersionUID = 1L;
    @ApiModelProperty(value="One or more component coordinates as package-url", required=true)
    @JsonProperty
    @XmlElementWrapper
    @XmlElement(name="coordinates")
    @XmlJavaTypeAdapter(value=PackageUrlXmlAdapter.class)
    private List<PackageUrl> coordinates;

    public ComponentReportRequest(List<PackageUrl> coordinates) {
        this.coordinates = coordinates;
    }

    public ComponentReportRequest() {
    }

    public List<PackageUrl> getCoordinates() {
        if (this.coordinates == null) {
            this.coordinates = new ArrayList<PackageUrl>();
        }
        return this.coordinates;
    }

    public void setCoordinates(List<PackageUrl> coordinates) {
        this.coordinates = coordinates;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentReportRequest that = (ComponentReportRequest)o;
        return Objects.equals(this.coordinates, that.coordinates);
    }

    public int hashCode() {
        return Objects.hash(this.coordinates);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("coordinates", this.coordinates).toString();
    }
}

