/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.ossindex.service.api.cvss;

import javax.annotation.Nullable;

public enum Cvss3Severity {
    UNKNOWN("unknown"),
    NONE("None"),
    LOW("Low"),
    MEDIUM("Medium"),
    HIGH("High"),
    CRITICAL("Critical");

    private final String label;

    private Cvss3Severity(String label) {
        this.label = label;
    }

    public String toString() {
        return this.label;
    }

    public static Cvss3Severity of(@Nullable Float score) {
        if (score != null) {
            if (score.floatValue() == 0.0f) {
                return NONE;
            }
            if (score.floatValue() > 0.0f && score.floatValue() < 4.0f) {
                return LOW;
            }
            if (score.floatValue() >= 4.0f && score.floatValue() < 7.0f) {
                return MEDIUM;
            }
            if (score.floatValue() >= 7.0f && score.floatValue() < 9.0f) {
                return HIGH;
            }
            if (score.floatValue() >= 9.0f && score.floatValue() <= 10.0f) {
                return CRITICAL;
            }
        }
        return UNKNOWN;
    }
}

