/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.ossindex.service.api.cvss;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.sonatype.ossindex.service.api.cvss.CvssMetric;
import org.sonatype.ossindex.service.api.cvss.CvssVector;

public class Cvss3Vector
extends CvssVector {
    public static final String VERSION = "3.0";
    public static final String PREAMBLE = "CVSS:3.0";
    public static final String ATTACK_VECTOR = "AV";
    public static final String ATTACK_COMPLEXITY = "AC";
    public static final String PRIVILEGES_REQUIRED = "PR";
    public static final String USER_INTERACTION = "UI";
    public static final String SCOPE = "S";
    public static final String CONFIDENTIALITY_IMPACT = "C";
    public static final String INTEGRITY_IMPACT = "I";
    public static final String AVAILABILITY_IMPACT = "A";
    private static final List<CvssMetric> BASE_METRICS = ImmutableList.of((Object)CvssMetric.builder().code("AV").group("Base").title("Attack Vector").meaning("N", "Network").meaning("A", "Adjacent Network").meaning("L", "Local").meaning("P", "Physical").build(), (Object)CvssMetric.builder().code("AC").group("Base").title("Attack Complexity").meaning("L", "Low").meaning("H", "High").build(), (Object)CvssMetric.builder().code("PR").group("Base").title("Privileges Required").meaning("N", "None").meaning("L", "Low").meaning("H", "High").build(), (Object)CvssMetric.builder().code("UI").group("Base").title("User Interaction").meaning("N", "None").meaning("R", "Required").build(), (Object)CvssMetric.builder().code("S").group("Base").title("Scope").meaning("U", "Unchanged").meaning("C", "Changed").build(), (Object)CvssMetric.builder().code("C").group("Base").title("Confidentiality Impact").meaning("N", "None").meaning("L", "Low").meaning("H", "High").build(), (Object)CvssMetric.builder().code("I").group("Base").title("Integrity Impact").meaning("N", "None").meaning("L", "Low").meaning("H", "High").build(), (Object)CvssMetric.builder().code("A").group("Base").title("Availability Impact").meaning("N", "None").meaning("L", "Low").meaning("H", "High").build());
    public static final String EXPLOIT_CODE_MATURITY = "E";
    public static final String REMEDIATION_LEVEL = "RL";
    public static final String REPORT_CONFIDENCE = "RC";
    public static final String CONFIDENTIALITY_REQUIREMENT = "CR";
    public static final String INTEGRITY_REQUIREMENT = "IR";
    public static final String AVAILABILITY_REQUIREMENT = "AR";
    private static final List<CvssMetric> OTHER_METRICS = ImmutableList.of((Object)CvssMetric.builder().code("E").group("Temporal").title("Exploit Code Maturity").meaning("X", "Not defined").meaning("H", "High").meaning("F", "Functional").meaning("P", "Proof-of-concept").meaning("U", "Unproven").build(), (Object)CvssMetric.builder().code("RL").group("Temporal").title("Remediation Level").meaning("X", "Not defined").meaning("U", "Unavailable").meaning("W", "Workaround").meaning("T", "Temporary fix").meaning("O", "Official fix").build(), (Object)CvssMetric.builder().code("RC").group("Temporal").title("Report Confidence").meaning("X", "Not defined").meaning("C", "Confirmed").meaning("R", "Reasonable").meaning("U", "Unknown").build(), (Object)CvssMetric.builder().code("CR").group("Environmental").title("Confidentiality Requirement").meaning("X", "Not defined").meaning("H", "High").meaning("M", "Medium").meaning("L", "Low").build(), (Object)CvssMetric.builder().code("IR").group("Environmental").title("Integrity Requirement").meaning("X", "Not defined").meaning("H", "High").meaning("M", "Medium").meaning("L", "Low").build(), (Object)CvssMetric.builder().code("AR").group("Environmental").title("Availability Requirement").meaning("X", "Not defined").meaning("H", "High").meaning("M", "Medium").meaning("L", "Low").build());
    private static final CvssMetric[] METRICS;
    private static final Map<String, CvssMetric> metrics;

    static {
        ArrayList<CvssMetric> all = new ArrayList<CvssMetric>();
        all.addAll(BASE_METRICS);
        all.addAll(OTHER_METRICS);
        for (CvssMetric metric : BASE_METRICS) {
            CvssMetric modified = CvssMetric.builder().from(metric).code("M" + metric.getCode()).title("Modified " + metric.getTitle()).meaning("X", "Not defined").build();
            all.add(modified);
        }
        METRICS = all.toArray(new CvssMetric[all.size()]);
        metrics = Cvss3Vector.createLookup(METRICS);
    }

    public Cvss3Vector(String value) {
        super(VERSION, Cvss3Vector.extractVector(value));
    }

    private static String extractVector(String value) {
        String prefix = "CVSS:3.0/";
        Preconditions.checkState((boolean)value.startsWith(prefix), (String)"Missing expected prefix: %s", (Object)prefix);
        return value.substring(prefix.length());
    }

    @Override
    @Nullable
    protected CvssMetric findMetric(String code) {
        return metrics.get(code);
    }
}

