/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.security.logging.log4j.mask;

import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.rewrite.RewritePolicy;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;
import org.apache.logging.log4j.core.impl.Log4jLogEvent;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.slf4j.Log4jMarker;
import org.owasp.security.logging.SecurityMarkers;

@Plugin(name="MaskingRewritePolicy", category="Core", elementType="rewritePolicy", printObject=true)
public class MaskingRewritePolicy
implements RewritePolicy {
    public static final Object MASKED_PASSWORD = "********";

    @PluginFactory
    public static MaskingRewritePolicy createPolicy() {
        return new MaskingRewritePolicy();
    }

    public LogEvent rewrite(LogEvent source) {
        Marker sourceMarker = source.getMarker();
        if (sourceMarker == null) {
            return source;
        }
        Message msg = source.getMessage();
        if (msg == null || !(msg instanceof ParameterizedMessage)) {
            return source;
        }
        Object[] params = msg.getParameters();
        if (params == null || params.length == 0) {
            return source;
        }
        Log4jMarker eventMarker = new Log4jMarker(sourceMarker);
        if (!eventMarker.contains(SecurityMarkers.CONFIDENTIAL)) {
            return source;
        }
        for (int i = 0; i < params.length; ++i) {
            params[i] = MASKED_PASSWORD;
        }
        ParameterizedMessage outMessage = new ParameterizedMessage(msg.getFormat(), params, msg.getThrowable());
        Log4jLogEvent output = new Log4jLogEvent(source.getLoggerName(), source.getMarker(), source.getLoggerFqcn(), source.getLevel(), (Message)outMessage, source.getThrown(), source.getContextMap(), source.getContextStack(), source.getThreadName(), source.getSource(), source.getTimeMillis());
        return output;
    }
}

