/*
 * Decompiled with CFR 0.152.
 */
package org.oxerr.huobi.examples.fix;

import java.io.IOException;
import java.io.InputStream;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.oxerr.huobi.fix.TradeApplication;
import org.oxerr.huobi.fix.fix44.AccountInfoResponse;
import org.oxerr.huobi.fix.fix44.HuobiMessageFactory;
import org.oxerr.huobi.fix.fix44.HuobiOrderInfoResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import quickfix.Application;
import quickfix.ConfigError;
import quickfix.FieldNotFound;
import quickfix.FileLogFactory;
import quickfix.FileStoreFactory;
import quickfix.IncorrectTagValue;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.SessionID;
import quickfix.SessionSettings;
import quickfix.SocketInitiator;
import quickfix.UnsupportedMessageType;
import quickfix.fix44.ExecutionReport;
import quickfix.fix44.OrderCancelReject;

public class TradeClient {
    private final Logger log = LoggerFactory.getLogger(TradeClient.class);
    private final TradeApplication app;
    private SessionID sessionId;
    private volatile boolean oneOrderDemoed;

    public TradeClient(String accessKey, String secretKey) throws IOException, ConfigError, InterruptedException {
        SessionSettings settings;
        this.app = new TradeApplication(accessKey, secretKey){

            public void onCreate(SessionID sessionId) {
                super.onCreate(sessionId);
                TradeClient.this.sessionId = sessionId;
            }

            public void onMessage(AccountInfoResponse message, SessionID sessionId) throws FieldNotFound, UnsupportedMessageType, IncorrectTagValue {
                TradeClient.this.log.info("AccReqID: {}", (Object)message.getAccReqID().getValue());
                TradeClient.this.log.info("Available BTC: {}", (Object)message.getAvailableBtc().getValue());
                TradeClient.this.log.info("Available LTC: {}", (Object)message.getAvailableLtc().getValue());
                TradeClient.this.log.info("Available CNY: {}", (Object)message.getAvailableCny().getValue());
                TradeClient.this.log.info("Frozen BTC: {}", (Object)message.getFrozenBtc().getValue());
                TradeClient.this.log.info("Frozen LTC: {}", (Object)message.getFrozenLtc().getValue());
                TradeClient.this.log.info("Frozen CNY: {}", (Object)message.getFrozenCny().getValue());
            }

            public void onMessage(HuobiOrderInfoResponse message, SessionID sessionId) throws FieldNotFound, UnsupportedMessageType, IncorrectTagValue {
                TradeClient.this.log.info("[HuobiOrderInfoResponse] Symbol: {}, orderID: {}, side: {}, price: {}, ordStatus: {}, quantity: {}, processedPrice: {}, processedAmount: {}, vot: {}, fee: {}, total: {}", new Object[]{message.getSymbol().getValue(), message.getOrderID().getValue(), message.getSide(), message.getPrice().getValue(), Character.valueOf(message.getOrdStatus().getValue()), message.getQuantity().getValue(), message.getProcessedPrice().getValue(), message.getProcessedAmount().getValue(), message.getVot().getValue(), message.getFee().getValue(), message.getTotal().getValue()});
            }

            public void onMessage(ExecutionReport message, SessionID sessionId) throws FieldNotFound {
                TradeClient.this.log.info("[ExecutionReport] ClOrdID: {}, orderID: {}, {} {}@{}, avgPx: {}, cumQty: {}, ordStatus: {}", new Object[]{message.getClOrdID().getValue(), message.getOrderID().getValue(), message.getSide().getValue() == '1' ? "buy" : "sell", message.isSetOrderQty() ? message.getOrderQty().getValue() : null, message.isSetPrice() ? message.getPrice().getValue() : null, message.isSetAvgPx() ? message.getAvgPx().getValue() : null, message.isSetCumQty() ? message.getCumQty().getValue() : null, message.isSetOrdStatus() ? Character.valueOf(message.getOrdStatus().getValue()) : null});
                if (!TradeClient.this.oneOrderDemoed) {
                    TradeClient.this.oneOrderDemoed = true;
                    TradeClient.this.log.info("Requesting one order status...");
                    TradeClient.this.app.requestOrderStatus(message.getOrderID().getValue(), message.getSide().getValue(), "btccny", sessionId);
                }
            }

            public void onMessage(OrderCancelReject message, SessionID sessionId) throws FieldNotFound, UnsupportedMessageType, IncorrectTagValue {
                TradeClient.this.log.info("[OrderCancelReject] Order cancel rejected. Requested cancelation ID: {}, orderID: {}, origClOrdID: {}, ordStatus: {}, text: {}.", new Object[]{message.getClOrdID().getValue(), message.getOrderID().getValue(), message.getOrigClOrdID().getValue(), Character.valueOf(message.getOrdStatus().getValue()), message.getText().getValue()});
            }
        };
        try (InputStream inputStream = this.getClass().getResourceAsStream("trade.cfg");){
            settings = new SessionSettings(inputStream);
        }
        FileStoreFactory storeFactory = new FileStoreFactory(settings);
        FileLogFactory logFactory = new FileLogFactory(settings);
        HuobiMessageFactory messageFactory = new HuobiMessageFactory();
        SocketInitiator initiator = new SocketInitiator((Application)this.app, (MessageStoreFactory)storeFactory, settings, (LogFactory)logFactory, (MessageFactory)messageFactory);
        initiator.start();
        while (!initiator.isLoggedOn()) {
            this.log.info("Waiting for logged on...");
            TimeUnit.SECONDS.sleep(1L);
        }
    }

    public void demo() throws InterruptedException, FieldNotFound {
        String accReqId = UUID.randomUUID().toString();
        this.log.info("Requesting AccountInfo, accReqId: {}", (Object)accReqId);
        this.app.requestAccountInfo(accReqId, "btc", this.sessionId);
        String massStatusReqId = UUID.randomUUID().toString();
        this.log.info("Requesting mass order stauts, massStatusReqId: {}", (Object)massStatusReqId);
        this.app.requestOrderMassStatus(massStatusReqId, 7, "btccny", this.sessionId);
    }

    public static void main(String[] args) throws IOException, ConfigError, InterruptedException, FieldNotFound {
        String accessKey = args[0];
        String secretKey = args[1];
        TradeClient tradeClient = new TradeClient(accessKey, secretKey);
        tradeClient.demo();
    }
}

