/*
 * Decompiled with CFR 0.152.
 */
package org.oxerr.huobi.examples.rest;

import com.xeiam.xchange.Exchange;
import com.xeiam.xchange.ExchangeFactory;
import com.xeiam.xchange.currency.CurrencyPair;
import com.xeiam.xchange.dto.marketdata.OrderBook;
import com.xeiam.xchange.dto.marketdata.Ticker;
import com.xeiam.xchange.dto.marketdata.Trades;
import com.xeiam.xchange.dto.trade.LimitOrder;
import com.xeiam.xchange.service.polling.marketdata.PollingMarketDataService;
import java.io.IOException;
import java.math.BigDecimal;
import org.oxerr.huobi.xchange.HuobiExchange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarketDataDemo {
    private static final Logger log = LoggerFactory.getLogger(MarketDataDemo.class);

    public static void main(String[] args) throws IOException {
        BigDecimal ask1;
        BigDecimal ask0;
        BigDecimal bid1;
        BigDecimal bid0;
        Exchange exchange = ExchangeFactory.INSTANCE.createExchange(HuobiExchange.class.getName());
        PollingMarketDataService marketDataService = exchange.getPollingMarketDataService();
        Ticker ticker = marketDataService.getTicker(CurrencyPair.BTC_CNY, new Object[0]);
        log.info("BTC ticker: {}", (Object)ticker);
        ticker = marketDataService.getTicker(CurrencyPair.LTC_CNY, new Object[0]);
        log.info("LTC ticker: {}", (Object)ticker);
        OrderBook depth = marketDataService.getOrderBook(CurrencyPair.BTC_CNY, new Object[0]);
        log.info("BTC depth: {}", (Object)depth);
        if (depth.getBids().size() >= 2 && (bid0 = ((LimitOrder)depth.getBids().get(0)).getLimitPrice()).compareTo(bid1 = ((LimitOrder)depth.getBids().get(1)).getLimitPrice()) <= 0) {
            throw new RuntimeException("bids in depth should be ordered from highest to lowest.");
        }
        if (depth.getAsks().size() >= 2 && (ask0 = ((LimitOrder)depth.getAsks().get(0)).getLimitPrice()).compareTo(ask1 = ((LimitOrder)depth.getAsks().get(1)).getLimitPrice()) >= 0) {
            throw new RuntimeException("asks in depth should be ordered from lowest to highest.");
        }
        depth = marketDataService.getOrderBook(CurrencyPair.LTC_CNY, new Object[0]);
        log.info("LTC depth: {}", (Object)depth);
        Trades trades = marketDataService.getTrades(CurrencyPair.BTC_CNY, new Object[0]);
        log.info("BTC trades: {}", (Object)trades);
    }
}

