/*
 * Decompiled with CFR 0.152.
 */
package org.oxerr.huobi.examples.websocket;

import java.net.MalformedURLException;
import java.net.URI;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.oxerr.huobi.websocket.HuobiSocketClient;
import org.oxerr.huobi.websocket.dto.DepthDiff;
import org.oxerr.huobi.websocket.dto.Percent;
import org.oxerr.huobi.websocket.dto.request.Request;
import org.oxerr.huobi.websocket.dto.request.historydata.ReqTimeLineRequest;
import org.oxerr.huobi.websocket.dto.request.marketdata.Message;
import org.oxerr.huobi.websocket.dto.request.marketdata.PushType;
import org.oxerr.huobi.websocket.dto.response.Response;
import org.oxerr.huobi.websocket.dto.response.historydata.ReqMarketDepthResponse;
import org.oxerr.huobi.websocket.dto.response.marketdata.MarketDepthDiff;
import org.oxerr.huobi.websocket.dto.response.marketdata.payload.MarketDepthDiffPayload;
import org.oxerr.huobi.websocket.dto.response.payload.Payload;
import org.oxerr.huobi.websocket.dto.response.payload.ReqMarketDepthPayload;
import org.oxerr.huobi.websocket.event.ResponseListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.bridge.SLF4JBridgeHandler;

public class WebSocketDemo {
    private static final Logger log = LoggerFactory.getLogger(WebSocketDemo.class);
    private static volatile ReqMarketDepthPayload depth;

    public static void main(String[] args) throws MalformedURLException, InterruptedException {
        SLF4JBridgeHandler.removeHandlersForRootLogger();
        SLF4JBridgeHandler.install();
        HuobiSocketClient client = new HuobiSocketClient(URI.create("http://hq.huobi.com:80").toURL());
        client.addListener(new ResponseListener(){

            public void onResponse(Response<? extends Payload> response) {
                log.info("{}", response);
                if (response instanceof ReqMarketDepthResponse) {
                    ReqMarketDepthResponse reqMarketDepthResponse = (ReqMarketDepthResponse)response;
                    depth = (ReqMarketDepthPayload)reqMarketDepthResponse.getPayload();
                    log.info("depth: {}", (Object)depth);
                } else if (response instanceof MarketDepthDiff) {
                    MarketDepthDiff marketDepthDiff = (MarketDepthDiff)response;
                    if (depth != null) {
                        depth.merge((DepthDiff)marketDepthDiff.getPayload());
                        log.info("merged depth: {}", (Object)depth);
                        if (((MarketDepthDiffPayload)marketDepthDiff.getPayload()).getBidInsert().getPrice().length > 0 || ((MarketDepthDiffPayload)marketDepthDiff.getPayload()).getAskInsert().getPrice().length > 0) {
                            System.exit(0);
                        }
                    }
                }
            }
        });
        client.connect();
        String btccny = "btccny";
        String ltccny = "ltccny";
        ReqTimeLineRequest req = new ReqTimeLineRequest(1, "btccny");
        req.setFrom(Instant.ofEpochMilli(1400000000L));
        req.setTo(Instant.ofEpochMilli(1400000220L));
        client.send((Request)req);
        Message message = new Message();
        message.addMarketDepthDiff("btccny", PushType.PUSH_LONG, Percent.PERCENT10);
        TimeUnit.MINUTES.sleep(1L);
        TimeUnit.SECONDS.sleep(5L);
        client.disconnect();
    }
}

